<?php

namespace Drupal\gat_tweaks\Plugin\WebformHandler;

use Drupal\Core\Form\FormStateInterface;
use Drupal\webform\Plugin\WebformHandlerBase;
use Drupal\Component\Utility\Html;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Webform validate handler.
 *
 * @WebformHandler(
 *   id = "gat_tweaks_custom_validator",
 *   label = @Translation("Alter form to validate it"),
 *   category = @Translation("Settings"),
 *   description = @Translation("Form alter to validate it."),
 *   cardinality = \Drupal\webform\Plugin\WebformHandlerInterface::CARDINALITY_SINGLE,
 *   results = \Drupal\webform\Plugin\WebformHandlerInterface::RESULTS_PROCESSED,
 *   submission = \Drupal\webform\Plugin\WebformHandlerInterface::SUBMISSION_OPTIONAL,
 * )
 */
class TicketWebformHandler extends WebformHandlerBase {

	use StringTranslationTrait;

  public function validateForm(array &$form, FormStateInterface $form_state, WebformSubmissionInterface $webform_submission) {
  	$this->validateDate($form_state);
  }

  /**
   * Validate Date.
   */
  private function validateDate(FormStateInterface $formState) {
    $current_date = date('Y-m-d');
    $check_in = $formState->getValue('check_in');
    $check_out = $formState->getValue('check_out');

    if ($check_in < $current_date) {
      $formState->setErrorByName('check_in', $this->t('"Check In" Date Should be Greater than or Equal Current Date.'));
    }

    if ($check_out <= $check_in) {
      $formState->setErrorByName('check_out', $this->t('"Check Out" Date Should be Greater than Check In.'));
    }
  }
}