<?php

namespace Drupal\gat_tweaks\Plugin\WebformHandler;

use Drupal\Core\Form\FormStateInterface;
use Drupal\webform\Plugin\WebformHandlerBase;
use Drupal\Component\Utility\Html;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Webform validate handler.
 *
 * @WebformHandler(
 *   id = "gat_tweaks_custom_validator_booknow",
 *   label = @Translation("validate Birth Date"),
 *   category = @Translation("Settings"),
 *   description = @Translation("Form alter to validate Birth Date."),
 *   cardinality = \Drupal\webform\Plugin\WebformHandlerInterface::CARDINALITY_SINGLE,
 *   results = \Drupal\webform\Plugin\WebformHandlerInterface::RESULTS_PROCESSED,
 *   submission = \Drupal\webform\Plugin\WebformHandlerInterface::SUBMISSION_OPTIONAL,
 * )
 */
class BooKNowWebformHandler extends WebformHandlerBase {

	use StringTranslationTrait;

  public function validateForm(array &$form, FormStateInterface $form_state, WebformSubmissionInterface $webform_submission) {
  	$this->validateBirthDate($form_state);
  }

  /**
   * Validate Date.
   */
  private function validateBirthDate(FormStateInterface $formState) {
    $current_date = date('Y-m-d');
    $valid_birth_date =  date('Y-m-d', strtotime($current_date. ' - 18 years'));
    $birth_date = $formState->getValue('birth_date');
    if ($birth_date > $valid_birth_date) {
       $formState->setErrorByName('birth_date', $this->t('Your Old Less than 18 years'));
    }
  }
}